﻿using System;
using System.Web.Mvc;
using MVC_App.Models;
using MVC_App.Validation;

namespace MVC_App.Controllers
{
	public partial class HomeController : Controller
	{
		private KreditkarteZahlungModel ValidateKreditkarteZahlung(BestellungForm bestellung)
		{
			var v = ModelStateValidator.Build(ModelState, bestellung).MoveToNode(p => p.Kreditkarte);

			var vName = v.Validate(p => p.Name).NotNullOrWhitespace();
			var vNummer = v.Validate(p => p.Nummer).NotNullOrWhitespace();

			var vGültigkeit = v.Validate(p => p.GültigBisMonat).NotNullOrWhitespace().ToInt32().InRange(1, 12)
				.Join(v.Validate(p => p.GültigBisJahr).NotNullOrWhitespace().ToInt32().InRange(2012, 2020),
					BuildDateTime);

			return vName.Join(vNummer, Tuple.Create)
				.Join(vGültigkeit, (p1, p2) => KreditkarteServiceGateway.CheckValidity(p1.Item1, p1.Item2, p2));
		}
	}

	public static class ValidationJoiner
	{
		public static ValidatingNode<TResult> Join<T1, T2, TResult>(
			this ValidatingNode<T1> v1,
			ValidatingNode<T2> v2,
			Func<T1, T2, TResult> transformer)
		{
			var merge = v1._errorWrapper.Merge(v2._errorWrapper);
			if (v1.DoEvaluate && v2.DoEvaluate)
			{
				try
				{
					var result = transformer(v1.Value, v2.Value);
					return new ValidatingNode<TResult>(result, merge);
				}
				catch (ValidationException ve)
				{
					return new ValidatingNode<TResult>(merge.SetError(ve.ErrorMessage));
				}
			}
			return new ValidatingNode<TResult>(merge);
		}
	}
}